/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class CMSDocumentSimple {
	
	private static final String FIELD_ACTIVE = "F_isactive";
	private static final String FIELD_TITEL = "F_titel";
	private Document doc = null;
	
	public CMSDocumentSimple (Document initialDoc) {
		doc = initialDoc;
	}
	public Document getDoc() {
		return doc;
	}
	public void setDoc(Document initialDoc) {
		doc = initialDoc;
	}
	public boolean isActive () throws NotesException {
		if (getDoc().hasItem(FIELD_ACTIVE)) {
			return getDoc().getItemValueInteger(FIELD_ACTIVE) == 1;
		} else {
			return false;
		}
	}
	public void setActive (boolean flag) throws NotesException {
		getDoc().replaceItemValue (FIELD_ACTIVE,new Integer (flag?1:0));
	}
	public String getTitle () throws NotesException {
		return doc.getItemValueString(FIELD_TITEL);
	}
	public Item setTitle (String t) throws NotesException {
		return doc.replaceItemValue(FIELD_TITEL, t);
	}	
}
